/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.planning.mokos.DefaultPositioner;
import cz.insophy.inplan.planning.mokos.MinimalTimeBound;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Positioner;
import cz.insophy.inplan.planning.mokos.PositioningResult;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class PositioningProcessor
extends Processor {
    private Positioner positioner;
    private boolean planWithTools;
    private boolean parallel;
    private final int availableProcessors;
    private final ExecutorService service;

    public PositioningProcessor() {
        this(new DefaultPositioner());
    }

    public PositioningProcessor(Positioner positioner) {
        this.setPositioner(positioner);
        this.planWithTools = true;
        this.parallel = true;
        this.availableProcessors = Runtime.getRuntime().availableProcessors();
        this.service = Executors.newFixedThreadPool(this.availableProcessors);
    }

    public void setPositioner(Positioner positioner) {
        Preconditions.checkNotNull(positioner, "Positioner cannot be null in PositioningProcessor.");
        this.positioner = positioner;
    }

    public void setPlanWithTools(boolean planWithTools) {
        this.planWithTools = planWithTools;
    }

    public Positioner getPositioner() {
        return this.positioner;
    }

    public boolean isPlanWithTools() {
        return this.planWithTools;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    private Set<Operation> positionOps(Collection<Operation> ops) {
        Superplan superplan = this.getScheduler().getSuperplan();
        Plan plan = superplan.getPlan();
        Set<Operation> resOps = Sets.newIdentityHashSet();
        for (Operation op : ops) {
            op.clearPlannings();
            MinimalTimeBound.BoundDefinition boundDef = op.getBound();
            long time = boundDef.getTime();
            for (Workplace wp : ImmutableList.copyOf(Iterables.filter(boundDef.getSpecifiers(), Workplace.class))) {
                long timeBound = superplan.getFixationDate() != -9223372036854775708L ? superplan.getFixationDate() : Long.MIN_VALUE;
                PositioningResult res = this.getPositioner().position(op.getGar(), op.getAction(), plan, wp, time, timeBound, this.isPlanWithTools());
                if (res.isOk()) {
                    op.addPlanning(res.getActivityChanges());
                    resOps.add(op);
                    continue;
                }
                op.updateCompositeBound(this, wp, res.getNextPossibleTime());
            }
        }
        return resOps;
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        Set<Operation> resOps = this.parallel && ops.size() >= 10 ? this.processParallel(ops) : this.positionOps(ops);
        return Tuple.create(this.getDefaultSuccessor(), resOps);
    }

    private Set<Operation> processParallel(Set<Operation> ops) {
        int partSize = Math.max(ops.size() / this.availableProcessors, 10);
        ImmutableList<Operation> opList = ImmutableList.copyOf(ops);
        ArrayList<Future<Set<Operation>>> futures = Lists.newArrayListWithCapacity(this.availableProcessors);
        Set<Operation> result = Sets.newIdentityHashSet();
        for (final List<Operation> list : Lists.partition(opList, partSize)) {
            Callable<Set<Operation>> callable = new Callable<Set<Operation>>(){

                @Override
                public Set<Operation> call() throws Exception {
                    return PositioningProcessor.this.positionOps(list);
                }
            };
            futures.add(this.service.submit(callable));
        }
        for (Future future : futures) {
            try {
                result.addAll((Collection)future.get());
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    @Override
    public void destroy() {
        this.service.shutdown();
    }
}

